/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model;

import org.jelsim.model.PropertyRegister;
import org.jelsim.system.ErrorHandler;

public class MonitorThread
implements Runnable {
    PropertyRegister reg = null;
    private int sleeptime = 200;
    Thread thread = null;
    private boolean running = true;
    private boolean suspendThread = false;

    MonitorThread(PropertyRegister reg, int sleeptime) {
        this.sleeptime = sleeptime;
        this.reg = reg;
    }

    public void finalizeJelsim() {
        this.running = false;
    }

    public synchronized void resume() {
        this.suspendThread = false;
        this.notify();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.reg.regInfoSent) {
            try {
                Thread.sleep(this.sleeptime);
            }
            catch (InterruptedException interruptedException) {}
        }
        block12: while (this.running) {
            try {
                this.reg.outputUpdate();
            }
            catch (Exception e) {
                ErrorHandler.reportExceptionExtra(e, "Monitor thread trapped exception ", this);
            }
            try {
                Thread.sleep(this.sleeptime);
            }
            catch (InterruptedException interruptedException) {}
            if (!this.suspendThread) continue;
            MonitorThread e = this;
            synchronized (e) {
                while (true) {
                    if (!this.suspendThread) {
                        continue block12;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        this.reg = null;
    }

    public synchronized void start() {
        this.thread = new Thread((Runnable)this, "Simulation monitor");
        this.thread.setDaemon(true);
        this.thread.setPriority(9);
        this.thread.start();
    }

    public synchronized void suspend() {
        this.suspendThread = true;
        this.notify();
    }
}

