/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TooManyListenersException;
import java.util.Vector;
import org.jelsim.model.MonitorThread;
import org.jelsim.model.PropertyRegister;
import org.jelsim.model.RegUpdate;
import org.jelsim.model.SimClass;
import org.jelsim.model.access.BrowserAccessInterface;
import org.jelsim.model.access.BrowserAccessProvider;
import org.jelsim.model.event.InterfaceUpdateEvent;
import org.jelsim.model.event.InterfaceUpdateListener;
import org.jelsim.model.event.JelsimActionEvent;
import org.jelsim.model.event.JelsimActionListener;
import org.jelsim.model.event.PropertyUpdateListener;
import org.jelsim.model.event.RefUpdateEvent;
import org.jelsim.model.event.RefUpdateListener;
import org.jelsim.model.event.TableUpdateEvent;
import org.jelsim.system.ErrorHandler;

public abstract class MainSimClass
extends SimClass
implements InterfaceUpdateListener,
JelsimActionListener,
RefUpdateListener,
Runnable {
    public static String lineSep = System.getProperty("line.separator");
    public static final int UNINITIALISED = 0;
    public static final int SUSPENDED = 1;
    public static final int STOPPED = 2;
    public static final int RUNNING = 4;
    protected BrowserAccessProvider browserAccessProvider = null;
    protected Thread mainSimThread = null;
    protected MonitorThread mthread = null;
    protected boolean running = true;
    protected boolean suspendedThread = false;
    protected Method runCalcMthd = null;
    public int loopDelay = 0;
    private PropertyUpdateListener propertyListener = null;
    protected boolean saveSetupSupported = true;
    public int mainThreadStatus = 0;
    public boolean sysReset = false;
    public String MVError = "";
    public String MVText = "";

    public MainSimClass() {
        this.mainClass = this;
        this.registerProperty("runStatus", "mainThreadStatus", 4);
        this.registerProperty("sysReset", "sysReset", 4);
        this.registerProperty("MVError", "MVError", 4);
        this.registerProperty("MVText", "MVText", 4);
        this.reg.setMainSimClass(this);
        Class[] parameterTypes = new Class[]{};
        try {
            this.runCalcMthd = this.getClass().getMethod("runCalc", parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorHandler.reportMessage("No user thread implemented", this);
        }
    }

    public MainSimClass(int monPause) {
        this();
        this.mthread = new MonitorThread(this.reg, monPause);
        this.mthread.start();
        ErrorHandler.reportMessage("Monitor thread started");
    }

    public void addPropertyUpdateListener(PropertyUpdateListener l) throws TooManyListenersException {
        if (this.propertyListener != null) {
            throw new TooManyListenersException("listener set already");
        }
        this.propertyListener = l;
        this.reg.setPropertyListener(l);
        this.reg.encodeRegInfo();
    }

    public void closeLinks() {
    }

    public void deleteSimClass(SimClass object) {
        this.reg.deleteClassInstance(object.getClass().getName(), object.getUniqueIdStr());
    }

    public void encodeRegInfo() {
        this.reg.encodeRegInfo();
        this.reg.sendAllUpdates();
    }

    public synchronized void finalizeJelsim() {
        this.running = false;
        if (this.mainSimThread != null) {
            this.mainSimThread = null;
        }
        if (this.mthread != null) {
            this.mthread.finalizeJelsim();
            this.mthread = null;
        }
        this.propertyListener = null;
        this.notify();
        this.reg.finalizeJelsim();
    }

    public void finished() {
        this.mainThreadStatus = 2;
        this.sendUpdate("runStatus");
    }

    public synchronized void forceMapUpdate() {
        this.reg.encodeRegInfo();
    }

    protected BrowserAccessInterface getBrowserAccess() {
        if (this.browserAccessProvider != null) {
            return this.browserAccessProvider.getBrowserAccess();
        }
        return null;
    }

    public RegUpdate getInitialisationData() {
        return this.reg.getEncodeVector();
    }

    public int getLoopDelay() {
        return this.loopDelay;
    }

    public Object getModelObject() {
        return null;
    }

    public Object getSaveState() {
        this.alreadySaved = true;
        return this.reg.getSaveState();
    }

    public void handleActionEvent(JelsimActionEvent e) {
        if (e.hasFilename()) {
            this.reg.invokeFileSpecial(e.getActionNumber(), e.getFilename());
        } else {
            this.reg.invokeActionMethod(e.getActionNumber());
        }
    }

    public void handleInterfaceUpdate(InterfaceUpdateEvent e) {
        this.reg.handleInterfaceUpdate(e);
    }

    public void handleRefUpdate(RefUpdateEvent e) {
        this.reg.handleRefUpdate(e);
    }

    public void handleTableUpdate(TableUpdateEvent e) {
        this.reg.handleTableUpdate(e);
    }

    public boolean isAlive() {
        if (this.mainSimThread != null) {
            return this.mainSimThread.isAlive();
        }
        return false;
    }

    public boolean isBuilderModel() {
        return false;
    }

    public synchronized void pause() {
        if (this.mainThreadStatus == 1) {
            this.mainThreadStatus = 4;
            this.suspendedThread = false;
            this.sendUpdate("runStatus");
            this.notify();
        } else if (this.mainThreadStatus == 4) {
            this.mainThreadStatus = 1;
            this.suspendedThread = true;
            this.sendUpdate("runStatus");
            this.notify();
        }
    }

    protected void registerActionMethod(String methodName, String menuString) {
        this.reg.registerActionMethod(methodName, menuString);
    }

    protected void registerActionMethod(String methodName, String submenuName, String menuString) {
        this.reg.registerActionMethod(methodName, submenuName, menuString);
    }

    public void registerCustomObject(String customObject) {
        this.reg.registerCustomObject(customObject);
    }

    public void registerDynamicProperty(SimClass sc, String propertyName, String fieldName, int type) {
        this.registerDynamicProperty(sc, propertyName, fieldName, type, null);
    }

    public void registerDynamicProperty(SimClass sc, String propertyName, String fieldName, int type, String methodName) {
        this.suspendMonitorThread();
        this.reg.registerDynamicProperty(sc, propertyName, fieldName, type, methodName);
        this.resumeMonitorThread();
    }

    protected void registerFileMethod(String methodName, String menuString) {
        this.reg.registerFileMethod(methodName, menuString);
    }

    public void removePropertyUpdateListener(PropertyUpdateListener l) {
        if (l == this.propertyListener) {
            this.propertyListener = null;
            this.reg.setPropertyListener(null);
        }
    }

    public synchronized void restart() {
        if (this.mainSimThread == null) {
            this.mainSimThread = new Thread((Runnable)this, "Model restart");
            this.mainSimThread.start();
        }
        this.runInitialise();
        this.mainThreadStatus = 4;
        this.sendUpdate("sysReset");
        this.suspendedThread = false;
        this.notify();
    }

    public void restoreModelObject(Object o) {
        if (o != null) {
            PropertyRegister.setLoadingRegister(this.reg);
            this.setModelObject(o);
            PropertyRegister.setLoadingRegister(null);
        }
    }

    public synchronized void resume() {
        this.mainThreadStatus = 4;
        this.suspendedThread = false;
        this.sendUpdate("runStatus");
        this.notify();
    }

    protected void resumeMonitorThread() {
        if (this.mthread != null) {
            this.mthread.resume();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block20: {
            block19: {
                if (this.runCalcMthd == null) break block19;
                runThread = this.mainSimThread;
                retVal = null;
                objects = new Object[]{};
                ** GOTO lbl48
                {
                    block18: {
                        try {
                            retVal = this.runCalcMthd.invoke((Object)this, objects);
                        }
                        catch (IllegalAccessException e) {
                            ErrorHandler.reportMessage("Access error in runCalc method, execution terminated", this);
                            ErrorHandler.reportException(e, this);
                            this.running = false;
                            ** GOTO lbl36
                        }
                        catch (InvocationTargetException e) {
                            ErrorHandler.reportMessage("Target error in runCalc method, execution terminated", this);
                            ErrorHandler.reportException(e, this);
                            this.running = false;
                            ** GOTO lbl36
                        }
                        try {
                            if (this.loopDelay > 0) {
                                Thread.sleep(this.loopDelay);
                            }
                            if (!this.suspendedThread) break block18;
                            e = this;
                            synchronized (e) {
                                while (this.suspendedThread) {
                                    this.wait();
                                }
                            }
                        }
                        catch (InterruptedException v1) {}
                    }
                    do {
                        if (this.runCheck()) continue block13;
lbl36:
                        // 3 sources

                        this.suspendedThread = true;
                        try {
                            e = this;
                            synchronized (e) {
                                while (this.suspendedThread) {
                                    this.wait();
                                }
                            }
                        }
                        catch (InterruptedException v3) {}
lbl48:
                        // 3 sources

                    } while (this.running);
                }
                ErrorHandler.reportMessage("Thread complete");
                this.finished();
                break block20;
            }
            ErrorHandler.reportMessage("No runCalc method defined for threaded model", this);
        }
    }

    public boolean runCheck() {
        ErrorHandler.reportMessage("MainSimClass: runCheck method has not been correctly extended", this);
        return false;
    }

    public void runInitialise() {
        ErrorHandler.reportMessage("MainSimClass: the programmer should provide a thread initialisation method", this);
    }

    public void setBrowserAccessProvider(BrowserAccessProvider provider) {
        this.browserAccessProvider = provider;
    }

    public void setLoopDelay(int loopDelay) {
        if (loopDelay < 0) {
            throw new IllegalArgumentException("Loop delay in runnable models must be > 1");
        }
        this.loopDelay = loopDelay;
    }

    public void setModelObject(Object o) {
    }

    public void setSaveState(Vector v) {
        this.reg.setSaveState(v);
        this.initialiseAfterSave();
    }

    public synchronized void start() {
        this.restart();
    }

    public synchronized void stop() {
        this.mainThreadStatus = 2;
        this.suspendedThread = true;
        this.notify();
    }

    public synchronized void suspend() {
        this.mainThreadStatus = 1;
        this.sendUpdate("runStatus");
        this.suspendedThread = true;
        this.notify();
    }

    protected void suspendMonitorThread() {
        if (this.mthread != null) {
            this.mthread.suspend();
        }
    }
}

