/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model;

import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Vector;
import org.jelsim.model.DotProperty;
import org.jelsim.model.LinkedProperty;
import org.jelsim.model.Property;
import org.jelsim.model.SimClass;
import org.jelsim.model.SimConst;
import org.jelsim.model.VectorProperty;
import org.jelsim.model.map.ClassTemplate;
import org.jelsim.model.map.MapProperty;
import org.jelsim.system.ErrorHandler;

public class ClassRegister
implements SimConst {
    private int nextPropertyId = 0;
    private int instanceNo = 0;
    private int classIdentifier = -1;
    private Vector instances = null;
    private Vector dotProperties = null;
    private Vector vecProperties = null;
    private Vector linkedProperties = null;
    private Vector SimClasses = null;
    private Vector inputs = null;
    private Vector outputs = null;
    private Vector allProperties = null;
    private ClassTemplate template = null;
    private Property uniqueProperty = null;
    private String className = null;

    public ClassRegister(SimClass sc) {
        this.className = sc.getClass().getName();
        this.instances = new Vector(5, 5);
        this.SimClasses = new Vector(5, 5);
        this.inputs = new Vector(5, 5);
        this.outputs = new Vector(5, 5);
        this.allProperties = new Vector(5, 5);
        Field[] flds = sc.getClass().getFields();
        int i = 0;
        while (i < flds.length) {
            String scname = this.SimClassName(flds[i].getType());
            if (scname != null) {
                this.SimClasses.addElement(scname);
            }
            ++i;
        }
    }

    private String SimClassName(Class c) {
        Class supc = c.getSuperclass();
        if (supc == null) {
            return null;
        }
        if (supc.getName().endsWith("SimClass")) {
            return c.getName();
        }
        return this.SimClassName(supc);
    }

    private void addIOLists(Property property) {
        if (property.getIOType() == 0) {
            this.inputs.addElement(property);
        } else {
            this.outputs.addElement(property);
            if (property.getIOType() == 2) {
                this.inputs.addElement(property);
            } else if (property.getIOType() == 4) {
                this.inputs.addElement(property);
            }
        }
    }

    public void addInstance(SimClass sc) {
        sc.setInstance(this.instanceNo++);
        this.instances.addElement(sc);
    }

    public void addProperty(Property p) {
        if (p instanceof DotProperty) {
            if (this.dotProperties == null) {
                this.dotProperties = new Vector(2, 2);
            }
            this.dotProperties.addElement(p);
            this.addIOLists(p);
        } else if (p instanceof VectorProperty) {
            if (this.vecProperties == null) {
                this.vecProperties = new Vector(2, 2);
            }
            this.vecProperties.addElement(p);
            this.addIOLists(p);
        } else if (p instanceof LinkedProperty) {
            if (this.linkedProperties == null) {
                this.linkedProperties = new Vector(2, 2);
            }
            this.linkedProperties.addElement(p);
        }
        this.allProperties.addElement(p);
    }

    protected void checkRestoredInstanceNumbers() {
        int maxId = -1;
        int recoveredId = -1;
        if (this.instances != null && this.instances.size() > 0) {
            String baseName = ((SimClass)this.instances.elementAt(0)).getUniqueNameBase();
            int i = 0;
            while (i < this.instances.size()) {
                SimClass instance = (SimClass)this.instances.elementAt(i);
                String uniqueId = instance.getUniqueIdStr();
                this.instanceNo = instance.getInstance();
                String justNum = uniqueId.substring(baseName.length());
                try {
                    recoveredId = Integer.parseInt(justNum);
                }
                catch (NumberFormatException numberFormatException) {
                    recoveredId = -1;
                }
                if (maxId < recoveredId) {
                    maxId = recoveredId;
                }
                ++i;
            }
        }
        if (maxId >= this.instanceNo) {
            this.instanceNo = maxId + 1;
        }
    }

    public void extendTemplateAndStorage(Property p) {
        int i = 0;
        while (i < this.instances.size()) {
            ((SimClass)this.instances.elementAt(i)).extendPropertyStorage(p);
            ++i;
        }
        this.template.addProperty(p.getName(), p.getSimType());
    }

    public void finalizeJelsim() {
        if (this.dotProperties != null) {
            this.dotProperties.removeAllElements();
            this.dotProperties = null;
        }
        if (this.vecProperties != null) {
            this.vecProperties.removeAllElements();
            this.vecProperties = null;
        }
        if (this.linkedProperties != null) {
            this.linkedProperties.removeAllElements();
            this.linkedProperties = null;
        }
        this.SimClasses = null;
        this.inputs.removeAllElements();
        this.inputs = null;
        this.outputs.removeAllElements();
        this.outputs = null;
        this.allProperties.removeAllElements();
        this.allProperties = null;
        Object template = null;
        int i = 0;
        while (i < this.instances.size()) {
            ((SimClass)this.instances.elementAt(i)).setRegisteredClass(null);
            ++i;
        }
        this.instances.removeAllElements();
        this.instances = null;
    }

    protected Vector getAllInstances() {
        return (Vector)this.instances.clone();
    }

    public int getClassIdentifier() {
        return this.classIdentifier;
    }

    public String getClassName() {
        return this.className;
    }

    public ClassTemplate getClassTemplate() {
        if (this.template == null) {
            if (this.instances.size() > 0) {
                SimClass base = (SimClass)this.instances.elementAt(0);
                String[] names = new String[this.allProperties.size()];
                int[] types = new int[names.length];
                Property p = null;
                int i = 0;
                while (i < names.length) {
                    p = (Property)this.allProperties.elementAt(i);
                    names[i] = p.getName();
                    types[i] = p.getSimType();
                    ++i;
                }
                this.template = new ClassTemplate(base.getClass().getName(), this.classIdentifier, names, types);
            } else {
                ErrorHandler.reportMessage("Error creating class template, no instances");
            }
        }
        return this.template;
    }

    protected Vector getInputProperties() {
        return this.inputs;
    }

    public SimClass getInstance(int instanceId) {
        SimClass retval = null;
        int i = 0;
        while (i < this.instances.size()) {
            if (((SimClass)this.instances.elementAt(i)).getInstance() == instanceId) {
                retval = (SimClass)this.instances.elementAt(i);
                break;
            }
            ++i;
        }
        return retval;
    }

    public SimClass getInstance(String uniqueIdString) {
        SimClass retval = null;
        int i = 0;
        while (i < this.instances.size()) {
            if (((SimClass)this.instances.elementAt(i)).getUniqueIdStr().equals(uniqueIdString)) {
                retval = (SimClass)this.instances.elementAt(i);
                break;
            }
            ++i;
        }
        return retval;
    }

    public int getInstanceCount() {
        int count = 0;
        if (this.instances != null) {
            count = this.instances.size();
        }
        return count;
    }

    protected Vector getInstanceMapProperties() {
        Vector<MapProperty[]> v = new Vector<MapProperty[]>(5);
        if (this.template == null) {
            this.getClassTemplate();
        }
        int i = 0;
        while (i < this.instances.size()) {
            SimClass base = (SimClass)this.instances.elementAt(i);
            v.addElement(base.getMapProperties());
            ++i;
        }
        return v;
    }

    protected Vector getOutputProperties() {
        return this.outputs;
    }

    public Property[] getProperties() {
        Object[] props = new Property[this.allProperties.size()];
        this.allProperties.copyInto(props);
        return props;
    }

    public Property getProperty(int propertyId) {
        return propertyId < this.allProperties.size() ? (Property)this.allProperties.elementAt(propertyId) : null;
    }

    protected Property getProperty(String name) {
        Property retval = null;
        int i = 0;
        while (i < this.allProperties.size()) {
            if (((Property)this.allProperties.elementAt(i)).getName().equals(name)) {
                retval = (Property)this.allProperties.elementAt(i);
                break;
            }
            ++i;
        }
        return retval;
    }

    public int getPropertyId() {
        return this.nextPropertyId++;
    }

    protected Object getPropertyValue(SimClass base, int index) {
        return ((Property)this.allProperties.elementAt(index)).getValue(base);
    }

    public String[] getStoredClasses() {
        Enumeration e = this.SimClasses.elements();
        String[] strs = new String[this.SimClasses.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            strs[i] = (String)e.nextElement();
            ++i;
        }
        return strs;
    }

    protected SimClass getUniqueInstance(Object uniqueValue) {
        SimClass retval = null;
        if (this.uniqueProperty != null) {
            int i = 0;
            while (i < this.instances.size()) {
                if (this.uniqueProperty.getValue((SimClass)this.instances.elementAt(i)).equals(uniqueValue)) {
                    retval = (SimClass)this.instances.elementAt(i);
                    break;
                }
                ++i;
            }
        }
        return retval;
    }

    protected Property getUniqueProperty() {
        return this.uniqueProperty;
    }

    public void initialiseSave() {
        int i = 0;
        while (i < this.instances.size()) {
            ((SimClass)this.instances.elementAt(i)).setAlreadySaved(false);
            ++i;
        }
    }

    protected SimClass removeInstance(int instanceId) {
        SimClass retval = this.getInstance(instanceId);
        if (retval != null) {
            this.instances.removeElement(retval);
        }
        return retval;
    }

    protected SimClass removeInstance(String uniqueIdString) {
        SimClass retval = this.getInstance(uniqueIdString);
        if (retval != null) {
            this.instances.removeElement(retval);
        }
        return retval;
    }

    public void setClassIdentifier(int id) {
        this.classIdentifier = id;
    }

    protected void setPropertyValue(SimClass base, int index, Object value) {
        ((Property)this.allProperties.elementAt(index)).setValue(base, value);
    }

    protected void setUniqueProperty(Property p) {
        if (this.uniqueProperty != null) {
            ErrorHandler.reportMessage("simReg: More than one unique property for " + this.className);
        }
        this.uniqueProperty = p;
    }

    public boolean templateExists() {
        return this.template != null;
    }
}

