/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.support;

import java.io.Serializable;
import org.jelsim.beans.support.BeanPropertyHelper;
import org.jelsim.beans.support.JSRectangle;
import org.jelsim.system.ErrorHandler;

public class JSClassHelper
implements Serializable {
    private String className = null;
    private int localId;
    private int globalId;
    private int version;
    private JSRectangle bounds;
    private BeanPropertyHelper[] modelProperties;
    private BeanPropertyHelper[] triggerProperties;
    private BeanPropertyHelper[] generalProperties;
    private Object[] customData;
    private JSClassHelper[] containedComponents;

    public JSClassHelper(Object obj) {
        this.className = obj.getClass().getName();
    }

    protected JSRectangle getBounds() {
        return this.bounds;
    }

    protected JSClassHelper[] getContainedComponents() {
        return this.containedComponents;
    }

    protected Object[] getCustomData() {
        return this.customData;
    }

    protected BeanPropertyHelper[] getGeneralProperties() {
        return this.generalProperties;
    }

    protected int getGlobalId() {
        return this.globalId;
    }

    protected int getLocalId() {
        return this.localId;
    }

    protected BeanPropertyHelper[] getModelProperties() {
        return this.modelProperties;
    }

    protected BeanPropertyHelper[] getTriggerProperties() {
        return this.triggerProperties;
    }

    protected int getVersion() {
        return this.version;
    }

    public Object newInstance() {
        Object retval = null;
        try {
            retval = Class.forName(this.className).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            ErrorHandler.reportExceptionExtra(cnfe, "Could not find the class " + this.className, this);
        }
        catch (InstantiationException ie) {
            ErrorHandler.reportExceptionExtra(ie, "Error instatiating an instance of " + this.className, this);
        }
        catch (IllegalAccessException iae) {
            ErrorHandler.reportExceptionExtra(iae, String.valueOf(this.className) + " cannot be instantiated", this);
        }
        return retval;
    }

    protected void setBounds(JSRectangle bounds) {
        this.bounds = bounds;
    }

    protected void setContainedComponents(JSClassHelper[] containedComponents) {
        this.containedComponents = containedComponents;
    }

    protected void setCustomData(Object[] customData) {
        this.customData = customData;
    }

    protected void setGeneralProperties(BeanPropertyHelper[] generalProperties) {
        this.generalProperties = generalProperties;
    }

    protected void setGlobalId(int globalId) {
        this.globalId = globalId;
    }

    protected void setLocalId(int localId) {
        this.localId = localId;
    }

    protected void setModelProperties(BeanPropertyHelper[] modelProperties) {
        this.modelProperties = modelProperties;
    }

    protected void setTriggerProperties(BeanPropertyHelper[] triggerProperties) {
        this.triggerProperties = triggerProperties;
    }

    protected void setVersion(int version) {
        this.version = version;
    }
}

