/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.lang.reflect.Method;
import java.util.Vector;
import org.jelsim.beans.support.BeanPropertyHelper;
import org.jelsim.beans.support.ComponentContainer;
import org.jelsim.beans.support.FmpHelper;
import org.jelsim.beans.support.JSClassHelper;
import org.jelsim.beans.support.JSColorHelper;
import org.jelsim.beans.support.JSExternalizableBean;
import org.jelsim.beans.support.JSFontHelper;
import org.jelsim.beans.support.JSRectangle;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.system.ErrorHandler;
import org.jelsim.trigger.TriggerCondition;
import org.jelsim.trigger.Triggerable;

public class BeanWriteHelper {
    private static BeanWriteHelper writeHelper = null;

    private BeanWriteHelper() {
    }

    public Object getByName(String name, JSExternalizableBean bean) {
        if (name == null) {
            return null;
        }
        StringBuffer methodName = new StringBuffer(name);
        methodName.setCharAt(0, Character.toUpperCase(methodName.charAt(0)));
        methodName.insert(0, "get");
        Method m = null;
        Object retval = null;
        try {
            m = bean.getClass().getMethod(methodName.toString(), new Class[0]);
            retval = m.invoke((Object)bean, new Object[0]);
        }
        catch (Exception exception) {
            retval = this.getByNameBoolean(name, bean);
        }
        if (retval instanceof Color) {
            retval = new JSColorHelper((Color)retval);
        } else if (retval instanceof Font) {
            retval = new JSFontHelper((Font)retval);
        }
        return retval;
    }

    private Object getByNameBoolean(String name, JSExternalizableBean bean) {
        StringBuffer methodName = new StringBuffer(name);
        methodName.setCharAt(0, Character.toUpperCase(methodName.charAt(0)));
        methodName.insert(0, "is");
        Method m = null;
        Object retval = null;
        try {
            m = bean.getClass().getMethod(methodName.toString(), new Class[0]);
            retval = m.invoke((Object)bean, new Object[0]);
        }
        catch (Exception e) {
            ErrorHandler.reportExceptionExtra(e, "Could not get object value for ", bean);
        }
        return retval;
    }

    private BeanPropertyHelper[] getGeneralProperties(JSExternalizableBean bean) {
        String[] normalSaveNames = bean.getNormalSaveNames();
        if (normalSaveNames == null) {
            return null;
        }
        Vector<BeanPropertyHelper> properties = new Vector<BeanPropertyHelper>(10);
        int i = 0;
        while (i < normalSaveNames.length) {
            Object o = this.getByName(normalSaveNames[i], bean);
            if (o != null) {
                properties.addElement(new BeanPropertyHelper(normalSaveNames[i], o));
            }
            ++i;
        }
        return properties.toArray(new BeanPropertyHelper[0]);
    }

    private BeanPropertyHelper[] getModelProperties(JSExternalizableBean bean) {
        return this.getModelProperties(bean, null);
    }

    public BeanPropertyHelper[] getModelProperties(JSExternalizableBean bean, ModelAccessInterface modelAccess) {
        String[] fmpSaveNames = bean.getFmpSaveNames();
        if (fmpSaveNames == null) {
            return null;
        }
        Vector<BeanPropertyHelper> properties = new Vector<BeanPropertyHelper>(5);
        int i = 0;
        while (i < fmpSaveNames.length) {
            ModelPropertyInterface mp = (ModelPropertyInterface)this.getByName(fmpSaveNames[i], bean);
            if (mp != null) {
                properties.addElement(new BeanPropertyHelper(fmpSaveNames[i], new FmpHelper(mp)));
                if (modelAccess != null) {
                    modelAccess.removeModelUpdateListener(mp, (ModelUpdateListener)((Object)bean));
                }
            }
            ++i;
        }
        return properties.toArray(new BeanPropertyHelper[0]);
    }

    private BeanPropertyHelper[] getTriggerProperties(JSExternalizableBean bean) {
        return this.getTriggerProperties(bean, null);
    }

    public BeanPropertyHelper[] getTriggerProperties(JSExternalizableBean bean, ModelAccessInterface modelAccess) {
        String[] triggerSaveNames = bean.getTriggerSaveNames();
        if (triggerSaveNames == null) {
            return null;
        }
        Vector<BeanPropertyHelper> properties = new Vector<BeanPropertyHelper>(5);
        int i = 0;
        while (i < triggerSaveNames.length) {
            TriggerCondition tc = (TriggerCondition)this.getByName(triggerSaveNames[i], bean);
            if (tc != null) {
                properties.addElement(new BeanPropertyHelper(triggerSaveNames[i], tc.getName()));
            }
            ++i;
        }
        return properties.toArray(new BeanPropertyHelper[0]);
    }

    public static BeanWriteHelper getWriteHelper() {
        return writeHelper == null ? (writeHelper = new BeanWriteHelper()) : writeHelper;
    }

    public synchronized void initialiseClassHelper(JSClassHelper classHelper, JSExternalizableBean bean) {
        Component[] components;
        classHelper.setLocalId(bean.getLocalId());
        classHelper.setGlobalId(bean.getGlobalId());
        classHelper.setVersion(bean.getVersion());
        classHelper.setBounds(new JSRectangle(bean.getBounds()));
        classHelper.setModelProperties(this.getModelProperties(bean));
        if (bean instanceof Triggerable) {
            classHelper.setTriggerProperties(this.getTriggerProperties(bean));
        }
        classHelper.setGeneralProperties(this.getGeneralProperties(bean));
        classHelper.setCustomData(bean.getCustomData());
        if (bean instanceof ComponentContainer && (components = ((ComponentContainer)((Object)bean)).getComponents()).length > 0) {
            Vector<JSClassHelper> v = new Vector<JSClassHelper>(10);
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof JSExternalizableBean) {
                    JSClassHelper ch = new JSClassHelper(components[i]);
                    this.initialiseClassHelper(ch, (JSExternalizableBean)((Object)components[i]));
                    v.addElement(ch);
                }
                ++i;
            }
            classHelper.setContainedComponents(v.toArray(new JSClassHelper[0]));
        }
    }
}

