/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.support;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import org.jelsim.beans.support.BeanInterface;
import org.jelsim.beans.support.BeanPropertyHelper;
import org.jelsim.beans.support.BeanReadHelper;
import org.jelsim.beans.support.BeanWriteHelper;
import org.jelsim.beans.support.HelpBeanInterface;
import org.jelsim.beans.support.JSExternalizableBean;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.beans.support.ShowError;
import org.jelsim.beans.support.ShowHelp;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.system.ErrorHandler;
import org.jelsim.trigger.Triggerable;

public abstract class BeanSupport
extends Component
implements BeanInterface,
HelpBeanInterface,
JSExternalizableBean {
    public static final long serialVersionUID = -4238822769559752331L;
    protected boolean resizable = false;
    protected boolean combinedResize = false;
    protected boolean editable = true;
    protected String title = "Null Property";
    protected transient ModelAccessInterface ma = null;
    protected int localId = -1;
    protected int globalId = -1;
    protected int width = 0;
    protected int height = 0;
    protected String userHelp = "";
    protected String editHelp = "Press to edit object properties";
    private int parentX;
    private int parentY;
    protected String[] fmpSaveNames = null;
    protected BeanPropertyHelper[] savedModelProperties = null;
    protected String[] triggerSaveNames = null;
    protected BeanPropertyHelper[] savedTriggerConditions = null;
    protected String[] normalSaveNames = null;
    protected final String nullTitle = "Null Property";
    protected int version = 1;

    public BeanSupport() {
        this.enableEvents(16L);
        this.enableEvents(32L);
    }

    public void adjustSize() {
    }

    public void clearHelp() {
        Container c = this.getParent();
        if (c != null && c instanceof ShowHelp) {
            ((ShowHelp)((Object)c)).clearHelp();
        }
    }

    public abstract void finalizeJelsim();

    protected void finalizeMP(ModelPropertyInterface mp) {
        if (mp != null) {
            this.ma.removeModelUpdateListener(mp, (ModelUpdateListener)((Object)this));
        }
    }

    public Object[] getCustomData() {
        return null;
    }

    public String getEditHelp() {
        return this.editHelp;
    }

    public String[] getFmpSaveNames() {
        return this.fmpSaveNames;
    }

    public int getGlobalId() {
        return this.globalId;
    }

    public int getLocalId() {
        return this.localId;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public ModelAccessInterface getModelAccess() {
        return this.ma;
    }

    public String[] getNormalSaveNames() {
        return this.normalSaveNames;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public BeanPropertyHelper[] getSavedModelProperties() {
        return this.savedModelProperties;
    }

    public Dimension getSize() {
        if (this.resizable) {
            return new Dimension(this.width, this.height);
        }
        return this.getPreferredSize();
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getTriggerSaveNames() {
        return this.triggerSaveNames;
    }

    public String getUserHelp() {
        return this.userHelp;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public boolean isinside(int deltax, int deltay) {
        int locx = this.getLocation().x;
        int locy = this.getLocation().y;
        return locx + deltax + this.width <= this.parentX && locx + deltax >= 0 && locy + deltay + this.height <= this.parentY && locy + deltay >= 0;
    }

    public void processMouseEvent(MouseEvent e) {
        if (this.editable && Beans.isDesignTime() && this.isEnabled()) {
            switch (e.getID()) {
                case 501: {
                    Dimension d = this.getParent().getSize();
                    this.parentX = d.width;
                    this.parentY = d.height;
                    break;
                }
            }
        }
        super.processMouseEvent(e);
    }

    public void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.width = w;
        this.height = h;
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setCustomData(Object[] data) {
    }

    public void setEditHelp(String help) {
        this.editHelp = help;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public void setGlobalId(int id) {
        this.globalId = id;
    }

    public void setLocalId(int id) {
        this.localId = id;
    }

    public void setModelAccess(ModelAccessInterface ma) {
        if (this.ma == ma) {
            return;
        }
        if (this.ma != null) {
            BeanWriteHelper writer = BeanWriteHelper.getWriteHelper();
            if (this.fmpSaveNames != null) {
                this.savedModelProperties = writer.getModelProperties(this, this.ma);
            }
            if (this instanceof Triggerable) {
                this.savedTriggerConditions = writer.getTriggerProperties(this, this.ma);
            }
        }
        this.ma = ma;
        BeanReadHelper readHelper = BeanReadHelper.getReadHelper();
        if (this.savedModelProperties != null) {
            BeanReadHelper.restoreModelProperties(this, this.savedModelProperties, ma);
            this.savedModelProperties = null;
        }
        if (this instanceof Triggerable && this.savedTriggerConditions != null) {
            BeanReadHelper.restoreTriggerConditions(this, this.savedTriggerConditions, ma);
            this.savedTriggerConditions = null;
        }
    }

    public void setResizable(boolean b) {
        this.resizable = b;
    }

    public void setSavedModelProperties(BeanPropertyHelper[] savedModelProperties) {
        this.savedModelProperties = savedModelProperties;
    }

    public void setSavedTriggers(BeanPropertyHelper[] savedTriggerConditions) {
        this.savedTriggerConditions = savedTriggerConditions;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
        super.setSize(w, h);
        this.repaint();
    }

    public void setTitle(String title) {
        this.title = title == null ? "Null Property" : title;
        this.sizeToFit();
    }

    public void setTriggerSaveNames(String[] triggerSaveNames) {
        this.triggerSaveNames = triggerSaveNames;
    }

    public void setUserHelp(String help) {
        this.userHelp = help;
    }

    public void setVersion(int ver) {
        this.version = ver;
    }

    public void showError(String errorStr) {
        Container c = this.getParent();
        if (c != null && c instanceof ShowError) {
            ((ShowError)((Object)c)).showError(errorStr);
        } else {
            ErrorHandler.reportMessage(errorStr);
        }
    }

    public void showHelp(String helpStr) {
        Container c = this.getParent();
        if (c != null && c instanceof ShowHelp) {
            ((ShowHelp)((Object)c)).showHelp(helpStr);
        }
    }

    public void sizeToFit() {
        if (!this.resizable || this.combinedResize) {
            this.adjustSize();
        }
    }

    public void update(Graphics g) {
    }
}

