/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.numberformatter;

import java.io.Serializable;
import java.math.BigDecimal;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.system.ErrorHandler;

public class NumberFormatter
implements Serializable {
    static final long serialVersionUID = 7332559305061545616L;
    public static int VALUE_UNSPECIFIED = -1;
    public static final int DEFAULT_NOTATION = 0;
    public static final int SCIENTIFIC_NOTATION = 1;
    public static final int FLOAT_NOTATION = 2;
    public static final int INTEGER_NOTATION = 3;
    public static final int OCTAL_NOTATION = 4;
    public static final int HEXADECIMAL_NOTATION = 5;
    protected String[] notationStrings = new String[]{"unformatted", "scientific", "floating point", "integer", "octal", "hexadecimal"};
    protected String formatString = null;
    protected int conversion = 0;
    protected int fieldWidth = VALUE_UNSPECIFIED;
    protected int decimalPlaces = VALUE_UNSPECIFIED;
    protected int placesInExponent = VALUE_UNSPECIFIED;
    protected int significantFigures = VALUE_UNSPECIFIED;
    protected int exponentMultiple = VALUE_UNSPECIFIED;
    protected boolean leftJustified = false;
    protected boolean showSignAlways = false;
    protected boolean paddedWithZeros = false;
    protected boolean exponentUpperCase = false;
    protected double valueMultiplier = 1.0;
    protected transient ModelAccessInterface ma = null;
    String prefixString = null;
    String postfixString = null;

    public NumberFormatter() {
    }

    public NumberFormatter(NumberFormatter nf) {
        this.setFormatString(nf.getFormatString());
        this.setConversion(nf.getConversion());
        this.setFieldWidth(nf.getFieldWidth());
        this.setDecimalPlaces(nf.getDecimalPlaces());
        this.setPlacesInExponent(nf.getPlacesInExponent());
        this.setSignificantFigures(nf.getSignificantFigures());
        this.setExponentMultiple(nf.getExponentMultiple());
        this.setLeftJustified(nf.isLeftJustified());
        this.setShowSignAlways(nf.isShowSignAlways());
        this.setPaddedWithZeros(nf.isPaddedWithZeros());
        this.setExponentUpperCase(nf.isExponentUpperCase());
        this.setValueMultiplier(nf.getValueMultiplier());
    }

    protected String convert(int format, double d) {
        int sign = 1;
        int exponent = 0;
        double mantissa = 0.0;
        int conversionType = format;
        if (conversionType == 0) {
            return Double.toString(d);
        }
        sign = d >= 0.0 ? 1 : -1;
        int ePos = 0;
        ePos = String.valueOf(d).indexOf(101);
        if (ePos == -1) {
            ePos = String.valueOf(d).indexOf(69);
        }
        if (ePos != -1) {
            exponent = Integer.parseInt(String.valueOf(d).substring(ePos + 1));
            mantissa = NumberFormatter.parseDouble(String.valueOf(d).substring(0, ePos));
            if (mantissa < 0.0) {
                mantissa = -mantissa;
            }
            if (conversionType == 2) {
                if (this.decimalPlaces != VALUE_UNSPECIFIED && (this.decimalPlaces < -(exponent + 1) || this.decimalPlaces == -(exponent + 1) && Math.rint(mantissa / 10.0) == 0.0)) {
                    d = 0.0;
                    sign = 1;
                    mantissa = 0.0;
                    exponent = 0;
                } else {
                    conversionType = 1;
                }
            }
        } else if (d == 0.0) {
            mantissa = 0.0;
            exponent = 0;
        } else {
            double number = Math.abs(d);
            exponent = -1;
            while (Math.pow(10.0, exponent) < number) {
                ++exponent;
            }
            while (Math.pow(10.0, exponent) > number) {
                --exponent;
            }
            mantissa = number * Math.pow(10.0, -exponent);
        }
        String retVal = this.generateString(conversionType, d, sign, mantissa, exponent);
        if (conversionType == 1 && retVal.startsWith("10.")) {
            retVal = this.generateString(conversionType, d, sign, mantissa / 10.0, exponent + 1);
        }
        return retVal;
    }

    protected int defaultConversion(Object object) {
        if (object instanceof Float || object instanceof Double) {
            return 2;
        }
        return 3;
    }

    public static String fixDecimalPlaces(double mantissa, int places) {
        String retValue = null;
        if (places == VALUE_UNSPECIFIED) {
            retValue = String.valueOf(mantissa);
        } else {
            BigDecimal bigDecimal = new BigDecimal(mantissa);
            BigDecimal roundedDecimal = bigDecimal.setScale(places, 6);
            retValue = roundedDecimal.toString();
        }
        return retValue;
    }

    protected String fixPadding(String sign, String mantissa, String exponent) {
        StringBuffer buf = new StringBuffer();
        int stringWidth = sign.length() + mantissa.length() + exponent.length();
        if (this.fieldWidth != VALUE_UNSPECIFIED) {
            if (this.ma != null && !this.ma.isApplet() && this.fieldWidth < stringWidth) {
                ErrorHandler.reportMessage("NumberFormatter: string width exceeds specified width");
                int i = 0;
                while (i < this.fieldWidth) {
                    buf.append('#');
                    ++i;
                }
            } else {
                StringBuffer pad1 = new StringBuffer();
                StringBuffer pad2 = new StringBuffer();
                StringBuffer pad3 = new StringBuffer();
                int i = 0;
                while (i < this.fieldWidth - stringWidth) {
                    if (this.paddedWithZeros) {
                        pad2.append('0');
                    } else if (this.leftJustified) {
                        pad3.append(' ');
                    } else {
                        pad1.append(' ');
                    }
                    ++i;
                }
                buf.append(String.valueOf(pad1.toString()) + sign + pad2.toString() + mantissa + exponent + pad3.toString());
            }
        } else {
            buf.append(String.valueOf(sign) + mantissa + exponent);
        }
        return buf.toString();
    }

    protected String generateString(int conversionType, double value, int sign, double mantissa, int exponent) {
        String retString = null;
        StringBuffer signBuf = new StringBuffer();
        StringBuffer exponentBuf = new StringBuffer();
        StringBuffer mantissaBuf = new StringBuffer();
        if (sign == -1) {
            signBuf.append('-');
        } else if (this.isShowSignAlways()) {
            signBuf.append('+');
        }
        if (conversionType == 1) {
            mantissaBuf = new StringBuffer(NumberFormatter.fixDecimalPlaces(mantissa, this.decimalPlaces));
        }
        if (conversionType == 1) {
            char exponentChar = exponent < 0 ? (char)'-' : '+';
            exponentBuf.append(Integer.toString(Math.abs(exponent)));
            while (this.placesInExponent > exponentBuf.length()) {
                exponentBuf.insert(0, '0');
            }
            exponentBuf.insert(0, exponentChar);
            exponentBuf.insert(0, this.isExponentUpperCase() ? (char)'E' : 'e');
        }
        if (conversionType == 2) {
            mantissaBuf = new StringBuffer(NumberFormatter.fixDecimalPlaces(Math.abs(value), this.decimalPlaces));
        }
        if (conversionType == 3) {
            mantissaBuf = new StringBuffer(Integer.toString((int)Math.abs(Math.rint(value))));
        }
        if (conversionType == 5) {
            mantissaBuf = new StringBuffer(Integer.toHexString((int)Math.abs(Math.rint(value))));
        }
        if (conversionType == 4) {
            mantissaBuf = new StringBuffer(Integer.toOctalString((int)Math.abs(Math.rint(value))));
        }
        retString = this.fixPadding(signBuf.toString(), mantissaBuf.toString(), exponentBuf.toString());
        return retString;
    }

    public int getConversion() {
        return this.conversion;
    }

    public String[] getConversionStrings() {
        return this.notationStrings;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public int getExponentMultiple() {
        return this.exponentMultiple;
    }

    public int getFieldWidth() {
        return this.fieldWidth;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public int getPlacesInExponent() {
        return this.placesInExponent;
    }

    public String getPostfixString() {
        return this.postfixString;
    }

    public String getPrefixString() {
        return this.prefixString;
    }

    public int getSignificantFigures() {
        return this.significantFigures;
    }

    public double getValueMultiplier() {
        return this.valueMultiplier;
    }

    public boolean isExponentUpperCase() {
        return this.exponentUpperCase;
    }

    public boolean isLeftJustified() {
        return this.leftJustified;
    }

    public boolean isPaddedWithZeros() {
        return this.paddedWithZeros;
    }

    public boolean isShowSignAlways() {
        return this.showSignAlways;
    }

    public static void main(String[] args) {
        NumberFormatter nf = new NumberFormatter();
        nf.setDecimalPlaces(2);
        String value = nf.toString(99999.999);
        boolean correct = value.equals("100000.00");
        System.out.println(correct);
    }

    protected String parseConversion(String string) {
        return string;
    }

    protected String parseDecimalPlaces(String string) {
        return string;
    }

    public static double parseDouble(String s) {
        return new Double(s);
    }

    protected String parseFieldWidth(String string) {
        return string;
    }

    protected void parseFormatString() {
        char[] conversionType = new char[]{'d', 'e', 'E'};
        int loc = this.formatString.indexOf(37);
        if (loc != -1) {
            String remainder = this.parsePrefixString(this.formatString);
            remainder = this.parseLeftJustification(remainder);
            remainder = this.parseFieldWidth(remainder);
            remainder = this.parseDecimalPlaces(remainder);
            this.postfixString = remainder = this.parseConversion(remainder);
        }
    }

    protected String parseLeftJustification(String string) {
        return string;
    }

    protected String parsePrefixString(String string) {
        this.prefixString = null;
        if (string == null) {
            return null;
        }
        int loc = this.formatString.indexOf(37);
        if (loc != -1) {
            if (loc > 0) {
                this.prefixString = string.substring(0, loc);
            }
            return string.substring(loc);
        }
        this.prefixString = string;
        return null;
    }

    public void setConversion(int conversion) {
        this.conversion = conversion;
    }

    public void setDecimalPlaces(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    public void setExponentMultiple(int exponentMultiple) {
        this.exponentMultiple = exponentMultiple;
    }

    public void setExponentUpperCase(boolean b) {
        this.exponentUpperCase = b;
    }

    public void setFieldWidth(int fieldWidth) {
        this.fieldWidth = fieldWidth;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public void setLeftJustified(boolean b) {
        this.leftJustified = b;
    }

    public void setModelAccess(ModelAccessInterface ma) {
        this.ma = ma;
    }

    public void setPaddedWithZeros(boolean b) {
        this.paddedWithZeros = b;
    }

    public void setPlacesInExponent(int placesInExponent) {
        this.placesInExponent = placesInExponent;
    }

    public void setPostfixString(String postfixString) {
        this.postfixString = postfixString;
    }

    public void setPrefixString(String prefixString) {
        this.prefixString = prefixString;
    }

    public void setShowSignAlways(boolean b) {
        this.showSignAlways = b;
    }

    public void setSignificantFigures(int significantFigures) {
        this.significantFigures = significantFigures;
    }

    public void setValueMultiplier(double d) {
        this.valueMultiplier = d;
    }

    public String toString(byte b) {
        return this.toString(new Byte(b));
    }

    public String toString(double d) {
        return this.toString(new Double(d));
    }

    public String toString(float f) {
        return this.toString(new Float(f));
    }

    public String toString(int i) {
        return this.toString(new Integer(i));
    }

    public String toString(long l) {
        return this.toString(new Long(l));
    }

    public String toString(Object object) {
        StringBuffer buf = new StringBuffer();
        if (this.prefixString != null) {
            buf.append(this.prefixString);
        }
        if (object instanceof Number) {
            Double dbl = new Double(((Number)object).doubleValue());
            if (dbl.isInfinite() || dbl.isNaN()) {
                return object.toString();
            }
            if (this.conversion != 0) {
                buf.append(this.convert(this.conversion, dbl));
            } else {
                buf.append(this.convert(this.defaultConversion(object), dbl));
            }
        } else {
            buf.append("0");
        }
        if (this.postfixString != null) {
            buf.append(this.postfixString);
        }
        return buf.toString();
    }

    public String toString(short s) {
        return this.toString(new Short(s));
    }
}

