/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.jelsim.applet.DrawingPanel;
import org.jelsim.applet.LoadingInformer;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.beans.support.ShowHelp;
import org.jelsim.model.MainSimClass;
import org.jelsim.model.access.AppletModelAccess;
import org.jelsim.model.access.ModelLoadException;
import org.jelsim.system.ErrorHandler;

public class JSApplet
extends Applet
implements ShowHelp,
LoadingInformer,
ActionListener,
Runnable {
    public static String LS = System.getProperty("line.separator");
    AppletModelAccess ma = null;
    Vector ifobjects = null;
    protected DrawingPanel dp = null;
    String helpStr = null;
    private boolean loadComplete = false;
    private String loadMessage = "Uninitialised";
    private String appletName = null;
    private TextArea errorMessages;
    private int delay = 0;
    private Thread delayThread;
    private Button okButton;
    int tlen = 0;

    public final void actionPerformed(ActionEvent e) {
        this.addDrawingPanel();
    }

    public void addActionMethods(Vector v) {
    }

    public void addCustomObjects(Vector v) {
    }

    private final void addDrawingPanel() {
        if (this.errorMessages != null) {
            this.removeAll();
            this.errorMessages = null;
            this.okButton.removeActionListener(this);
            this.okButton = null;
        }
        this.add((Component)this.dp, "Center");
        this.dp.setVisible(true);
        this.validate();
        this.repaint();
    }

    public void addFileSpecials(Vector v) {
    }

    private final void addMessagePanel() {
        this.errorMessages = new TextArea("", 10, 80);
        this.errorMessages.setFont(new Font("SansSerif", 0, 14));
        this.errorMessages.setForeground(new Color(71, 71, 117));
        this.add((Component)this.errorMessages, "Center");
        this.errorMessages.setVisible(true);
        Panel buttonPanel = new Panel(new GridLayout(0, 1, 0, 0));
        this.okButton = new Button("Continue");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        this.add((Component)buttonPanel, "North");
        this.validate();
        this.repaint();
    }

    public void clearHelp() {
        this.getAppletContext().showStatus("            ");
        this.helpStr = null;
    }

    private final void delayStart(int delay) {
        if (delay > 0) {
            this.print("The \"Continue\" button will be enabled in approx " + delay + " seconds");
            this.tlen = this.errorMessages.getText().length();
            this.delay = delay * 1000;
            this.delayThread = new Thread(this);
            this.delayThread.setPriority(1);
            this.delayThread.start();
        } else {
            this.println("Click on the \"Continue\" button above to view the eSim");
            this.okButton.setEnabled(true);
        }
    }

    private String getAppletName() {
        String myName = this.getParameter("name");
        if (myName == null) {
            myName = this.getClassName();
        }
        return myName;
    }

    private String getClassName() {
        String className = this.getClass().getName();
        int i = className.lastIndexOf(".");
        className = className.substring(i + 1, className.length());
        return className;
    }

    public String getDocumentName() {
        return null;
    }

    public String getHelpText() {
        return this.helpStr;
    }

    public Component getIndexedBean(int index) {
        if (this.ifobjects != null) {
            return (Component)this.ifobjects.elementAt(index);
        }
        return null;
    }

    public String getLoadMessage() {
        return this.loadMessage;
    }

    public ModelAccessInterface getModelAccess() {
        return this.ma;
    }

    public MainSimClass getModelInstance() {
        String className = this.getParameter("modelClass");
        Object retval = null;
        try {
            retval = Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            ErrorHandler.reportExceptionExtra(cnfe, "Could not find the class " + className, this);
        }
        catch (InstantiationException ie) {
            ErrorHandler.reportExceptionExtra(ie, "Error instatiating an instance of " + className, this);
        }
        catch (IllegalAccessException iae) {
            ErrorHandler.reportExceptionExtra(iae, String.valueOf(className) + " cannot be instantiated", this);
        }
        return retval;
    }

    private void getModelObjects() {
        block11: {
            try {
                String inparam = null;
                inparam = this.getParameter("loadFile");
                if (inparam == null) break block11;
                URL url = new URL(String.valueOf(this.getCodeBase().toString()) + inparam);
                try {
                    if (url.getProtocol().toLowerCase().equals("file")) {
                        this.ma.readIfObjectsFile(url.getFile());
                    } else {
                        this.ma.readIfObjectsURL(new URL(String.valueOf(this.getCodeBase().toString()) + inparam));
                    }
                    if (this.dp != null) {
                        this.dp.initialiseBeanObjects();
                    }
                }
                catch (ModelLoadException mle) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        ErrorHandler.reportException(e, this);
                    }
                    ErrorHandler.reportMessage("Error loading model " + mle, this);
                    if (mle.hasTarget()) {
                        ErrorHandler.reportException(mle.getTargetException(), this);
                    }
                }
                catch (IOException iOException) {
                    ErrorHandler.reportMessage("Error getting file from url " + url.getFile());
                }
            }
            catch (MalformedURLException e) {
                ErrorHandler.reportExceptionExtra(e, "URL in error", this);
            }
        }
        this.ifobjects = this.ma.getObjectVector();
        this.clearHelp();
    }

    public void init() {
        super.init();
        this.appletName = this.getAppletName();
        this.setLayout(new BorderLayout());
        this.setLoadMessage("Initialising...");
        this.loadComplete = false;
    }

    private boolean initModel() {
        boolean initSuccess = true;
        this.setLayout(new BorderLayout());
        try {
            try {
                if (this.ma == null) {
                    try {
                        this.ma = new AppletModelAccess(this.getModelInstance());
                    }
                    catch (Exception exception) {
                        this.showHelp("Cannot access model.");
                        initSuccess = false;
                    }
                }
                if (initSuccess) {
                    if (this.dp != null) {
                        this.dp.clearAll();
                        this.dp = null;
                    }
                    if (this.dp == null) {
                        this.dp = new DrawingPanel(1000, 1000, this, true);
                        this.showHelp(this.setLoadMessage("Loading interface objects..."));
                    }
                    this.ma.initialiseBrowserAccess(this, this.getCodeBase());
                    this.dp.setModelAccess(this.ma);
                    this.getModelObjects();
                }
            }
            catch (ExceptionInInitializerError eii) {
                this.showError(eii.toString());
                initSuccess = false;
            }
            catch (Exception e) {
                this.showError(e.toString());
                initSuccess = false;
            }
            Object var3_4 = null;
            this.setLoadMessage("Applet Loaded");
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.setLoadMessage("Applet Loaded");
            this.loadComplete = true;
            throw throwable;
        }
        this.loadComplete = true;
        this.validate();
        this.repaint();
        return initSuccess;
    }

    public void invokeActionMethod(String methodName) {
        this.ma.invokeActionMethod(methodName);
    }

    public boolean isLoaded() {
        return this.loadComplete;
    }

    private final void print(String str) {
        this.errorMessages.append(str);
    }

    private final void println() {
        this.errorMessages.append(LS);
    }

    private final void println(String str) {
        this.errorMessages.append(str);
        this.println();
    }

    public final void run() {
        String[] chars = new String[]{"|", "/", "-", "\\"};
        int count = 0;
        int elapsed = 0;
        while (elapsed < this.delay) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            this.errorMessages.replaceRange(chars[count], this.tlen - 1, this.tlen);
            elapsed += 100;
            if (++count < 4) continue;
            count = 0;
        }
        this.println();
        this.println("--- Press \"continue\" to move on");
        this.okButton.setEnabled(true);
    }

    public void setDocumentName(String s) {
    }

    private synchronized String setLoadMessage(String s) {
        this.loadMessage = s;
        return s;
    }

    private void showError(String msg) {
        this.showHelp("Error : " + msg);
    }

    public void showHelp(String s) {
        this.helpStr = s;
        AppletContext ac = this.getAppletContext();
        if (ac != null) {
            ac.showStatus(this.helpStr);
        } else {
            ErrorHandler.reportMessage(this.helpStr, this);
        }
    }

    private void showJelsimMessage() {
        this.println("This applet was created using JeLSIM tools.");
        this.println("http://www.jelsim.org/");
        this.println("");
    }

    public final void start() {
        super.start();
        if (this.initModel()) {
            if (this.ma.getModelStatus() == 5) {
                this.addDrawingPanel();
            } else {
                this.addMessagePanel();
                this.showJelsimMessage();
                switch (this.ma.getModelStatus()) {
                    case 6: {
                        this.delayStart(0);
                        break;
                    }
                    case 0: {
                        this.println("No license keys were available when this applet was");
                        this.println("created. Please contact your supplier or JeLSIM.org");
                        this.println("to arrange for appropriate licences keys to be installed");
                        this.println();
                        this.delayStart(0);
                        break;
                    }
                    case 1: {
                        this.println("NO DEPLOYMENT KEYS WERE ACTIVE WHEN THIS APPLET WAS DEPLOYED");
                        this.println();
                        this.delayStart(0);
                        break;
                    }
                    case 2: {
                        this.println("An internal deploy error (SIT) has been detected,");
                        this.println("please contact JeLSIM for further information.");
                        this.println();
                        this.delayStart(5);
                        break;
                    }
                    case 3: {
                        this.println("This applet has been licensed to run on a number of hosts but");
                        this.println("but this does not include " + this.getCodeBase().getHost());
                        this.println();
                        this.println("Please contact your supplier or JeLSIM if you wish to");
                        this.println("license the applet to run from additional hosts");
                        this.println();
                        this.delayStart(10);
                        break;
                    }
                    case 4: {
                        this.println("THE CURRENT MODEL DOES NOT APPEAR IN THE DEPLOYMENT KEY");
                        this.println();
                        this.delayStart(10);
                        break;
                    }
                    case 7: {
                        this.println("An error was detected in the deployment records that are associated");
                        this.println("with this applet.  Please contact your supplier or JeLSIM to verify");
                        this.println("whether or not this applet should run from the current web-server");
                        this.println();
                        break;
                    }
                    default: {
                        this.println("There was a sequencing error when the model keys were accessed");
                        this.delayStart(0);
                        break;
                    }
                }
            }
            this.setLoadMessage("Applet started");
        }
    }

    public void stop() {
        this.loadComplete = false;
        this.loadMessage = "Terminating";
        if (this.dp != null) {
            this.dp.clearAll();
            this.dp = null;
        }
        if (this.ma != null) {
            this.ma.finalizeJelsim();
            this.ma = null;
        }
        this.removeAll();
        super.stop();
    }

    public void toggleEdit(boolean b) {
    }
}

